#ifndef WARNINGS_H
#define WARNINGS_H

#include <afxtempl.h>
#include "max.h"

enum TWarningType { wtInformational, wtWarning, wtError };

class CWarning
{
private:
    TWarningType FWarningType;
    CString FNodeName;
    CString FMessage;
public:
    CWarning();
    CWarning(TWarningType Type, CString NodeName, CString Message);
    ~CWarning();
    CString getNodeName( void );
    CString getMessage( void );
    TWarningType getType( void );
};

class WarningList
{
public:
    int m_ClumpCount;
    int m_FrameCount;
    int m_AtomicCount;
    int m_NodeCount;
    int m_TriangleCount;
    int m_VertexCount;
    int m_RotKeys;
    int m_TransKeys;
    WarningList();
    ~WarningList();
    void add( CWarning &warning );
    int getNumWarnings( void );
    CWarning getElement( int element );
    void saveToFile( FILE *fd );
    int numInformationals( void );
    int numWarnings( void );
    int numErrors( void );
    void zeroMetrics();
    void writeVersion();
    void newFrame( const char *NodeName );
    void newClump( const char *NodeName );
    void writtenFile( const char *Filename );
private:
    CList<CWarning,CWarning&> FWarningList;
    int FNumInformationals;
    int FNumWarnings;
    int FNumErrors;
};

#endif